/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.distort;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.SimplexDomainWarp;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherMinSDF;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.text.NumberFormat;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class DistortTool
implements Tool {
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final float[] distance = new float[]{2.0f};
    private final int[] scale = new int[]{16};
    private final int[] iterations = new int[]{2};
    private final int[] seed = new int[]{0};
    private boolean separateAxis = false;
    private final float[] distanceX = new float[]{2.0f};
    private final float[] distanceY = new float[]{2.0f};
    private final float[] distanceZ = new float[]{2.0f};
    private boolean smoothEdges = true;
    private final PresetWidget presetWidget = new PresetWidget(this, "distort");
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    @Override
    public void reset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.INSTANCE.release("distort");
        }
        this.blockRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                float amplitudeZ;
                float amplitudeY;
                float amplitudeX;
                class_638 level;
                this.reset();
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.INSTANCE.acquire("distort");
                }
                if ((level = class_310.method_1551().field_1687) == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                int iterations = this.iterations[0];
                if (this.separateAxis) {
                    amplitudeX = this.distanceX[0] * 50.0f / (float)iterations;
                    amplitudeY = this.distanceY[0] * 50.0f / (float)iterations;
                    amplitudeZ = this.distanceZ[0] * 50.0f / (float)iterations;
                } else {
                    amplitudeY = amplitudeZ = this.distance[0] * 50.0f / (float)iterations;
                    amplitudeX = amplitudeZ;
                }
                float frequency = 1.0f / (float)this.scale[0];
                int seed = this.seed[0];
                if (this.smoothEdges) {
                    AsyncToolPather pather = this.createToolPatherSmoothEdges(level, mutableBlockPos, iterations, amplitudeX, amplitudeY, amplitudeZ, frequency, seed);
                    this.pathProvider = new AsyncToolPathProvider(pather);
                } else {
                    AsyncToolPather pather = this.createToolPatherNoSmoothEdges(level, mutableBlockPos, iterations, amplitudeX, amplitudeY, amplitudeZ, frequency, seed);
                    this.pathProvider = new AsyncToolPathProvider(pather);
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrix, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrix, projection, 7);
                return;
            }
            Selection.render(camera, time, matrix, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrix, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.blockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.distorted", countString);
            RegionHelper.pushBlockRegionChange(this.blockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.blockRegion.render(camera, class_243.field_1353, matrix, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private AsyncToolPather createToolPatherNoSmoothEdges(class_638 level, class_2338.class_2339 mutableBlockPos, int iterations, float amplitudeX, float amplitudeY, float amplitudeZ, float frequency, int seed) {
        MaskElement sourceMaskElement = MaskManager.getSourceMask();
        MaskElement destMaskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2680 air = class_2246.field_10124.method_9564();
        return new AsyncToolPatherUnique(this.brushWidget.getBrushShape(), (x, y, z) -> {
            if (!destMaskElement.test(maskContext.reset(), x, y, z)) {
                return;
            }
            Vector3d vector3d = new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            for (int i = 0; i < iterations; ++i) {
                SimplexDomainWarp.SingleDomainWarpOpenSimplex2Gradient(seed, amplitudeX, amplitudeY, amplitudeZ, frequency, vector3d);
            }
            float replacableWeight = 0.0f;
            float nonreplacableWeight = 0.0f;
            Object2FloatArrayMap blockWeights = new Object2FloatArrayMap();
            int blockX = (int)Math.floor(vector3d.x);
            int blockY = (int)Math.floor(vector3d.y);
            int blockZ = (int)Math.floor(vector3d.z);
            float fracX = (float)(vector3d.x - (double)blockX);
            float fracY = (float)(vector3d.y - (double)blockY);
            float fracZ = (float)(vector3d.z - (double)blockZ);
            for (int xo = -1; xo <= 1; ++xo) {
                float weightX = 1.0f - Math.min(1.0f, Math.abs((float)xo - fracX + 0.5f));
                for (int yo = -1; yo <= 1; ++yo) {
                    float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)yo - fracY + 0.5f)));
                    for (int zo = -1; zo <= 1; ++zo) {
                        float weightXYZ = weightXY * (1.0f - Math.min(1.0f, Math.abs((float)zo - fracZ + 0.5f)));
                        if (weightXYZ <= 0.0f) continue;
                        class_2680 blockState = !sourceMaskElement.test(maskContext.reset(), blockX + xo, blockY + yo, blockZ + zo) ? air : level.method_8320((class_2338)mutableBlockPos.method_10103(blockX + xo, blockY + yo, blockZ + zo));
                        if (blockState.method_26215()) {
                            blockState = class_2246.field_10124.method_9564();
                        }
                        if (blockState.method_45474()) {
                            replacableWeight += weightXYZ;
                        } else {
                            nonreplacableWeight += weightXYZ;
                        }
                        blockWeights.computeFloat((Object)blockState, (block, value) -> Float.valueOf(value == null ? weightXYZ : value.floatValue() + weightXYZ));
                    }
                }
            }
            boolean useCanBeReplaced = replacableWeight >= nonreplacableWeight;
            class_2680 closestState = AIR;
            float closestWeight = Float.MIN_VALUE;
            for (Object2FloatMap.Entry entry : blockWeights.object2FloatEntrySet()) {
                class_2680 blockState = (class_2680)entry.getKey();
                if (blockState.method_45474() != useCanBeReplaced || !(entry.getFloatValue() > closestWeight)) continue;
                closestState = blockState;
                closestWeight = entry.getFloatValue();
            }
            if (!closestState.method_26216((class_1922)class_2682.field_12294, class_2338.field_10980)) {
                ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, AIR);
            }
            this.blockRegion.addBlock(x, y, z, closestState);
        });
    }

    private AsyncToolPather createToolPatherSmoothEdges(class_638 level, class_2338.class_2339 mutableBlockPos, int iterations, float amplitudeX, float amplitudeY, float amplitudeZ, float frequency, int seed) {
        MaskElement sourceMaskElement = MaskManager.getSourceMask();
        MaskElement destMaskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2680 air = class_2246.field_10124.method_9564();
        return new AsyncToolPatherMinSDF(this.brushWidget.getBrushShape(), (x, y, z, distance) -> {
            if (!destMaskElement.test(maskContext.reset(), x, y, z)) {
                return;
            }
            float falloff = 0.0f;
            if ((double)distance > 0.6) {
                falloff = (distance - 0.6f) / 0.4f;
            }
            float scaledAmplitudeX = amplitudeX * (1.0f - falloff);
            float scaledAmplitudeY = amplitudeY * (1.0f - falloff);
            float scaledAmplitudeZ = amplitudeZ * (1.0f - falloff);
            Vector3d vector3d = new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            for (int i = 0; i < iterations; ++i) {
                SimplexDomainWarp.SingleDomainWarpOpenSimplex2Gradient(seed, scaledAmplitudeX, scaledAmplitudeY, scaledAmplitudeZ, frequency, vector3d);
            }
            float replacableWeight = 0.0f;
            float nonreplacableWeight = 0.0f;
            Object2FloatArrayMap blockWeights = new Object2FloatArrayMap();
            int blockX = (int)Math.floor(vector3d.x);
            int blockY = (int)Math.floor(vector3d.y);
            int blockZ = (int)Math.floor(vector3d.z);
            float fracX = (float)(vector3d.x - (double)blockX);
            float fracY = (float)(vector3d.y - (double)blockY);
            float fracZ = (float)(vector3d.z - (double)blockZ);
            for (int xo = -1; xo <= 1; ++xo) {
                float weightX = 1.0f - Math.min(1.0f, Math.abs((float)xo - fracX + 0.5f));
                for (int yo = -1; yo <= 1; ++yo) {
                    float weightXY = weightX * (1.0f - Math.min(1.0f, Math.abs((float)yo - fracY + 0.5f)));
                    for (int zo = -1; zo <= 1; ++zo) {
                        float weightXYZ = weightXY * (1.0f - Math.min(1.0f, Math.abs((float)zo - fracZ + 0.5f)));
                        class_2680 blockState = !sourceMaskElement.test(maskContext.reset(), blockX + xo, blockY + yo, blockZ + zo) ? air : level.method_8320((class_2338)mutableBlockPos.method_10103(blockX + xo, blockY + yo, blockZ + zo));
                        if (blockState.method_26215()) {
                            blockState = class_2246.field_10124.method_9564();
                        }
                        if (blockState.method_45474()) {
                            replacableWeight += weightXYZ;
                        } else {
                            nonreplacableWeight += weightXYZ;
                        }
                        blockWeights.computeFloat((Object)blockState, (block, value) -> Float.valueOf(value == null ? weightXYZ : value.floatValue() + weightXYZ));
                    }
                }
            }
            boolean useCanBeReplaced = replacableWeight >= nonreplacableWeight;
            class_2680 closestState = class_2246.field_10124.method_9564();
            float closestWeight = Float.MIN_VALUE;
            for (Object2FloatMap.Entry entry : blockWeights.object2FloatEntrySet()) {
                class_2680 blockState = (class_2680)entry.getKey();
                if (blockState.method_45474() != useCanBeReplaced || !(entry.getFloatValue() > closestWeight)) continue;
                closestState = blockState;
                closestWeight = entry.getFloatValue();
            }
            if (!closestState.method_26216((class_1922)class_2682.field_12294, class_2338.field_10980)) {
                ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, AIR);
            }
            this.blockRegion.addBlock(x, y, z, closestState);
        });
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.distort.distortion"));
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.distort.scale"), this.scale, 2, 32);
        if (this.separateAxis) {
            changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.distort.distance_x"), this.distanceX, 0.0f, 16.0f, "%.2f");
            changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.distort.distance_y"), this.distanceY, 0.0f, 16.0f, "%.2f");
            changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.distort.distance_z"), this.distanceZ, 0.0f, 16.0f, "%.2f");
        } else {
            changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.distort.distance"), this.distance, 1.0f, 16.0f, "%.2f");
        }
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.distort.iterations"), this.iterations, 1, 5);
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.distort.separate_axis"), this.separateAxis)) {
            boolean bl = this.separateAxis = !this.separateAxis;
            if (this.separateAxis) {
                this.distanceX[0] = this.distance[0];
                this.distanceY[0] = this.distance[0];
                this.distanceZ[0] = this.distance[0];
            } else {
                this.distance[0] = (this.distanceX[0] + this.distanceY[0] + this.distanceZ[0]) / 3.0f;
            }
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
        changed |= ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.generic.noise_seed"), this.seed);
        if (ImGui.button(AxiomI18n.get("axiom.tool.generic.noise_seed_do_randomize"))) {
            this.seed[0] = ThreadLocalRandom.current().nextInt();
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.advanced_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.distort.smooth_edges"), this.smoothEdges)) {
            this.smoothEdges = !this.smoothEdges;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.distort");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Distort Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10569("DistortionScale", this.scale[0]);
        tag.method_10556("SeparateAxis", this.separateAxis);
        if (this.separateAxis) {
            tag.method_10548("DistanceX", this.distanceX[0]);
            tag.method_10548("DistanceY", this.distanceY[0]);
            tag.method_10548("DistanceZ", this.distanceZ[0]);
        } else {
            tag.method_10548("Distance", this.distance[0]);
        }
        tag.method_10567("Iterations", (byte)this.iterations[0]);
        tag.method_10569("Seed", this.seed[0]);
        tag.method_10556("SmoothEdges", this.smoothEdges);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.scale[0] = NbtGetter.getIntOrDefault(tag, "DistortionScale", 16);
        this.separateAxis = NbtGetter.getBoolOrDefault(tag, "SeparateAxis", false);
        if (this.separateAxis) {
            this.distanceX[0] = NbtGetter.getFloatOrDefault(tag, "DistanceX", 2.0f);
            this.distanceY[0] = NbtGetter.getFloatOrDefault(tag, "DistanceY", 2.0f);
            this.distanceZ[0] = NbtGetter.getFloatOrDefault(tag, "DistanceZ", 2.0f);
        } else {
            this.distance[0] = NbtGetter.getFloatOrDefault(tag, "Distance", 2.0f);
        }
        this.iterations[0] = NbtGetter.getIntOrDefault(tag, "Iterations", 2);
        this.seed[0] = NbtGetter.getIntOrDefault(tag, "Seed", 0);
        this.smoothEdges = NbtGetter.getBoolOrDefault(tag, "SmoothEdges", true);
    }

    @Override
    public char iconChar() {
        return '\ue915';
    }

    @Override
    public String keybindId() {
        return "distort";
    }
}

